unit CompPict;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tPict = class(tDrawComponent)
  private
  public
    Glyph: Graphics.TBitmap;
    Transparent: Boolean;
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    procedure GetExtent(var aMin, aMax: tPoint); override;
    function GetRgn: hRgn; override;
    procedure Paint; override;
    procedure SetPropList; override;
  end;

var dciPicture: Integer;

implementation

{$R *.res}

uses Dialogs, SysUtils, Jpeg,
     GDIPAPI, GDIPOBJ;

constructor tPict.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 15;
  Glyph:= Graphics.TBitmap.Create;
  inherited CreateByBasicName(aOwner, 'Picture');
  Glyph.Handle:= LoadBitMap(hInstance, 'DEFAULT');
  Transparent:= True;
  className:= 'Picture';
  CreatingByAddPoint:= True;
end;

constructor tPict.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

procedure tPict.GetExtent(var aMin, aMax: Windows.tPoint);
var i: Integer;
begin
  if Left< aMin.X then aMin.X:= Left;
  if (Left+ Width)> aMax.X then aMax.X:= Left+ Width;
  if Top< aMin.Y then aMin.Y:= Top;
  if (Top+ Height)> aMax.Y then aMax.Y:= Top+ Height;
  for i:= 0 to ComponentCount- 1 do
    tDrawComponent(Components[i]).GetExtent(aMin, aMax);
end;

function tPict.GetRgn: hRgn;
begin
  Result:= CreateRectRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
end;

procedure tPict.Paint;
procedure GrayScale(var B1, B2: Graphics.tBitmap);
var i, j, CCC: Integer;
begin
  for i:= 1 to B1.Width do
    for j:= 1 to B1.Height do
    begin
      CCC:= Round((GetRed(B1.Canvas.Pixels[i, j])+
                   GetGreen(B1.Canvas.Pixels[i, j])+
                   GetBlue(B1.Canvas.Pixels[i, j]))/3);
      B2.Canvas.Pixels[i, j]:= RGB(CCC, CCC, CCC);
    end;
end;
var Temp: Graphics.tBitmap;
begin
  Glyph.Transparent:= Transparent;
  if DrawFace.Printing then
  begin
    Temp:= Graphics.tBitmap.Create;
    Temp.Assign(Glyph);
    GrayScale(Temp, Glyph);
  end;
  with DrawFace.Canvas do
  begin
    Pen.Mode:= pmCOPY;
    StretchDraw(Rect(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
                     Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
                     Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
                     Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y),
                     Glyph);
  end;
  if DrawFace.Printing then
  begin
    Glyph.Assign(Temp);
    Temp.Free;
  end;
  inherited;
end;

procedure tPict.SetPropList;
begin
  inherited;
  with PropList do
  begin
    Kill('Color');
    Kill('Linecolor');
    Kill('Linewidth');
    Add(tBooleanProp.CreateBooleanProp(@Transparent, 'Transparent'));
    Add(tGlyphProp.CreateProp(Glyph, 'Picture'));
  end;
end;

initialization

  //dci -> DrawComponentIndex

  dciPicture:= Face.DrawCompItemList.Add(tDrawCompItem.Create('Picture', tPict));

end.
